

#include "Invites.h"
#include "MessagePipe.h"
#include "MatchingSony.h"
#include "MessagingSony.h"

#include <system_service.h>



#define INVITE_MANUALLY_HANDLE_ATTACHMENT (1)
#define INVITE_JOIN_SESSION (0)
#define INVITE_JOIN_MATCHING_SESSION (0)


using namespace sce::Toolkit::NP;
using namespace sce::Toolkit::NP::Utilities;

namespace UnityPlugin
{
	Invites gInvites;

	Invites::Invites()
	{

	}
	void Invites::Update()
	{
		SceSystemServiceStatus status;
		SceSystemServiceEvent event;
		int ret = SCE_OK;

		ret = sceSystemServiceGetStatus(&status);
		if ((ret == SCE_OK) && (status.eventNum > 0))
		{
			for (int i = 0; i < status.eventNum; i++)
			{
				ret = sceSystemServiceReceiveEvent(&event);
				if (ret == SCE_OK)
				{
					if(event.eventType == SCE_SYSTEM_SERVICE_EVENT_SESSION_INVITATION)
					{
						SceNpSessionInvitationEventParam* eventParam = (SceNpSessionInvitationEventParam*)event.data.param;

#if INVITE_MANUALLY_HANDLE_ATTACHMENT
						// attempt to use Messaging::Interface::retrieveMessageAttachmentFromEvent() and Matching::Interface::joinInvitedSession
						UnityPlugin::gMessaging.ProcessMatchingInviteMessage(eventParam);	
#elif INVITE_JOIN_SESSION

						//Get userId from onlineId structure of and set param.request.useerInfo.userId
						sce::Toolkit::NP::JoinNpSessionRequest sessionReq;
						sceUserServiceGetInitialUser(&sessionReq.userInfo.userId);

						if (eventParam->flag == SCE_NP_SESSION_INVITATION_EVENT_FLAG_INVITATION)
						{
							sessionReq.invite = true;
							memcpy(sessionReq.invitationParam,event.data.param,sizeof(sessionReq.invitationParam));
						}
						else
						{
							sessionReq.invite = false;
						}

						memcpy(&sessionReq.npSessionId,&eventParam->sessionId,sizeof(sessionReq.npSessionId));
						ret = sce::Toolkit::NP::Sessions::Interface::join(&sessionReq,&m_JoinSession);

#elif INVITE_JOIN_MATCHING_SESSION

						// join a matching session given the session id from the invite, using  Matching::Interface::joinInvitedSessionFromNpSessionId()
						UnityPlugin::gMatching.JoinSessionFromId(&eventParam->sessionId);
#endif

						return;
					}
				}
			}
		}

	}

	bool Invites::ProcessEvent(const sce::Toolkit::NP::Event& event)
	{
		SimpleLock::AutoLock lock(m_Lock);
		bool handled = false;

		return handled;
	}



}
